% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions_implementations.R
\name{Constraint}
\alias{Constraint}
\alias{dconstraint}
\alias{rconstraint}
\title{Constraint calculations in NIMBLE}
\usage{
dconstraint(x, cond, log = FALSE)

rconstraint(n = 1, cond)
}
\arguments{
\item{x}{value indicating whether \code{cond} is TRUE or FALSE}

\item{cond}{logical value}

\item{log}{logical; if TRUE, probability density is returned on the log scale.}

\item{n}{number of observations (only \code{n=1} is handled currently).}
}
\value{
\code{dconstraint} gives the density and \code{rconstraint} generates random deviates,
but these are unusual as the density is 1 if \code{x} matches \code{cond} and
0 otherwise and the deviates are simply the value of \code{cond}
}
\description{
Calculations to handle censoring
}
\details{
Used for working with constraints in BUGS code.
See the NIMBLE manual for additional details.
}
\examples{
constr <- 3 > 2 && 4 > 0
x <- rconstraint(1, constr)
dconstraint(x, constr)
dconstraint(0, 3 > 4)
dconstraint(1, 3 > 4)
rconstraint(1, 3 > 4)
}
\author{
Christopher Paciorek
}
\seealso{
\link{Distributions} for other standard distributions
}

