% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_vaa.R
\name{get_vaa}
\alias{get_vaa}
\title{NHDPlusV2 Attribute Subset}
\usage{
get_vaa(atts = NULL, path = get_vaa_path(), download = TRUE)
}
\arguments{
\item{atts}{character The variable names you would like, always includes comid}

\item{path}{character path where the file should be saved. Default is a
persistent system cache as retrieved by \link[rappdirs]{user_cache_dir}.
Also see: \link{get_vaa_path}}

\item{download}{logical if TRUE, the default, will download VAA table if not
found at path.}
}
\value{
data.frame
}
\description{
Return requested NHDPlusv2 Attributes
}
\details{
The VAA data is a aggregate table of information from the NHDPlusV2
elevslope.dbf(s), PlusFlowlineVAA.dbf(s); and NHDFlowlines. All data
originates from the EPA NHDPlus Homepage
\href{https://www.epa.gov/waterdata/get-nhdplus-national-hydrography-dataset-plus-data}{here}.
To see the location of cached data on your machine use
\code{\link{get_vaa_path}}.
To view aggregate data and documentation, see
\href{https://www.hydroshare.org/resource/6092c8a62fac45be97a09bfd0b0bf726/}{here}
}
\examples{
\donttest{
get_vaa("slope")
get_vaa(c("slope", "lengthkm"))

#cleanup if desired
unlink(get_vaa_path(), recursive = TRUE)
}
}
