% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_nflverse.R
\name{load_pfr_advstats}
\alias{load_pfr_advstats}
\title{Load Advanced Stats from PFR}
\usage{
load_pfr_advstats(
  seasons = most_recent_season(),
  stat_type = c("pass", "rush", "rec", "def")
)
}
\arguments{
\item{seasons}{a numeric vector specifying what seasons to return, if \code{TRUE} returns all available data}

\item{stat_type}{one of "pass", "rush", "rec", "def"}
}
\value{
A tibble of week-level player statistics provided by Pro Football Reference to supplement data in nflverse
}
\description{
Loads player level season stats provided by Pro Football Reference
starting with the 2018 season, primarily to augment existing nflverse data.
}
\examples{
\donttest{
  load_pfr_advstats()
}

}
\seealso{
\url{https://www.pro-football-reference.com/years/2021/passing_advanced.htm}
}
