% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{mean}
\alias{mean}
\alias{mean,CompositionMatrix-method}
\title{Compositional Mean}
\usage{
\S4method{mean}{CompositionMatrix}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{na.rm}{A \code{\link{logical}} scalar: should missing values be removed?}
}
\value{
A \code{\link{numeric}} vector.
}
\description{
Compositional Mean
}
\details{
Closed vector of the columns geometric means.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Mean
mean(coda)

## Quantile
quantile(coda)

## Metric variance
metric_var(coda)

## Metric standard deviation
metric_sd(coda)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall, p. 64-91.
}
\seealso{
Other statistics: 
\code{\link{aggregate}()},
\code{\link{covariance}()},
\code{\link{dist}},
\code{\link{mahalanobis}()},
\code{\link{margin}()},
\code{\link{metric_var}()},
\code{\link{quantile}()},
\code{\link{scale}()},
\code{\link{variation}()}
}
\author{
N. Frerebeau
}
\concept{statistics}
