% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representations.R
\name{representations}
\alias{representations}
\alias{repr_adjacency}
\alias{repr_laplacian}
\alias{repr_modularity}
\alias{repr_graphon}
\title{Network Representation Functions}
\usage{
repr_adjacency(network, validate = TRUE)

repr_laplacian(network, validate = TRUE)

repr_modularity(network, validate = TRUE)

repr_graphon(network, validate = TRUE)
}
\arguments{
\item{network}{An \code{\link[igraph]{igraph}} object.}

\item{validate}{A boolean specifying whether the function should check the
class of its input (default: \code{TRUE}).}
}
\value{
A numeric square matrix giving the desired network representation
recorded in the object's class.
}
\description{
This is a collection of functions that convert a graph stored as an
\code{\link[igraph]{igraph}} object into a desired matrix representation
among adjacency matrix, graph laplacian, modularity matrix or graphon (edge
probability matrix).
}
\examples{
g <- igraph::sample_smallworld(1, 25, 3, 0.05)
repr_adjacency(g)
repr_laplacian(g)
repr_modularity(g)
repr_graphon(g)
}
