% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nv_atlas_region.R
\name{nv_atlas_region}
\alias{nv_atlas_region}
\title{Neurovault Query Atlas Region}
\usage{
nv_atlas_region(region, collection_name, atlas_name, verbose = TRUE,
  secure = TRUE, ...)
}
\arguments{
\item{region}{Region to search or query on}

\item{collection_name}{Collection name of the atlas}

\item{atlas_name}{Name of the atlas}

\item{verbose}{print diagnostic messages}

\item{secure}{passed to \code{\link{nv_base_url}} for https}

\item{...}{additional options to pass to \code{\link{GET}}}
}
\value{
List of the result of the \code{\link{GET}} call and
the content
}
\description{
Searches atlas for specified region and related synonyms.
If no matches are found, it will search the NIF ontology
recursively for children of the specified region that are
found in the atlas. If no matches are found,
it will search recursively for parents that are found in the atlas.
Returns the corresponding to the X, Y and Z coordinates,
 respectively, of the matching voxels. Coordinates are in mm in MNI space.
}
\examples{
res = nv_atlas_region(
region = "middle frontal gyrus",
collection_name = "Harvard-Oxford cortical and subcortical structural atlases",
atlas_name = "HarvardOxford cort maxprob thr25 1mm")
head(res$content$voxels)
}
