% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AllClass.R, R/BrainVolume.R
\docType{class}
\name{ClusteredBrainVolume-class}
\alias{ClusteredBrainVolume}
\alias{ClusteredBrainVolume-class}
\title{ClusteredBrainVolume}
\usage{
ClusteredBrainVolume(mask, clusters, labelMap = NULL, source = NULL,
  label = "")
}
\arguments{
\item{mask}{an instance of class \code{\linkS4class{LogicalBrainVolume}}}

\item{clusters}{a vector of clusters ids with length equal to number of nonzero voxels in mask \code{mask}}

\item{labelMap}{an optional \code{list} that maps from cluster id to a cluster label, e.g. (1 -> "FFA", 2 -> "PPA")}

\item{source}{an optional instance of class \code{\linkS4class{BrainSource}}}

\item{label}{an optional \code{character} string used to label of the volume}
}
\value{
\code{\linkS4class{ClusteredBrainVolume}} instance
}
\description{
Three-dimensional brain image that is divided into N disjoint partitions

Construct a \code{\linkS4class{ClusteredBrainVolume}} instance
}
\examples{
bspace <- BrainSpace(c(16,16,16), spacing=c(1,1,1))
grid <- indexToGrid(bspace, 1:(16*16*16))
kres <- kmeans(grid, centers=10)
mask <- BrainVolume(rep(1, 16^3),bspace)
clusvol <- ClusteredBrainVolume(mask, kres$cluster)
}

