% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_list_files.R
\name{parse_list_files}
\alias{parse_list_files}
\title{Parse listed files from HCP bucket}
\usage{
parse_list_files(ret)
}
\arguments{
\item{ret}{object with element \code{parsed_result}, usually from
\code{\link{hcp_list_files}}}
}
\value{
List of 2 data.frames, the contents and the
\code{commonprefixes}
elements from the list
}
\description{
This parses the result from \code{\link{hcp_list_files}} and
organizes the files into \code{data.frame}s
}
\examples{
if (have_aws_key()){
   ret = hcp_list_files(prefix = "HCP/100307/unprocessed/3T/Diffusion")
   parsed = parse_list_files(ret)
   stopifnot(!is.null(parsed$contents))
 }
}
