sim.fmri.ts <-
function(design=list(), nscan=NULL, TR=NULL, SNR, noise=c("none", "white", "temporal", "low-frequency", "physiological", "task-related", "mixture"), temp=c("AR(1)", "state-space"), weights, verbose=TRUE, rho=NULL, lowfreq=NULL, heartfreq=NULL, respfreq=NULL){

	# design: list generated by simprep.act.temp specifying the design. If not specified, noise time series are generated.
	# SNR: signal-to-noise ratio of the time series
	# noise: type of noise (white is default)
	# temp: if noise=temporal, type of temporal noise (AR(1) is default)
	# weights: if noise=mixture, vector of weights to specify the fraction of the noise components
	# verbose: logical indicating if warnings should be returned
	# rho: if noise=temporal or noise=mixture, value of autocorrelation coefficient
	# lowfreq: if noise=low-frequency or noise=mixture, frequency of the low-frequency drift in seconds
	# heartfreq: if noise=physiological or noise=mixture, frequency of heart rate in Hz
	# respfreq: if noise=physiological or noise=mixture, frequency of respiratory rate in Hz
	
	if(missing(noise)){
		noise <- "white"
	}
	if(noise=="temporal" || noise=="mixture"){
		if(missing(temp)){
			temp <- "AR(1)"
		}
	}
	if(noise=="mixture"){
		if(missing(weights)){
			stop("Weights should be provided with noise=mixture.")
		}
		if(length(weights)!=5){
			stop("Weights vector should have 5 elements.")
		}
		if(sum(weights)!=1){
			stop("The sum of the weights vector should be equal to 1.")
		}
	}

	if(length(design)==0){
		act <- 0
		sigma <- SNR
		if(is.null(TR)){
			stop("TR value is missing.")
		}
		if(is.null(nscan)){
			stop("nscan value is missing.")
		}
	} else if(length(design)>1){
		stop("Multiple regions are undefined for time series.")
	} else {
		act <-rowSums(specify.design(design[[1]]$ncond, design[[1]]$onsets, design[[1]]$durations, design[[1]]$T, design[[1]]$TR, design[[1]]$acc, conv=design[[1]]$hrf, par=design[[1]]$par))
		sigma <- sd(act)/SNR
		TR <- design[[1]]$TR
		nscan <- design[[1]]$T/design[[1]]$TR
	}

	if(noise=="none"){
		n <- 0
	}
	if(noise=="white"){
		n <- c(gaussnoise.fnc(c(1), sigma, nscan, verbose=verbose))
	}
	if(noise=="temporal"){
		if(temp=="AR(1)"){
			n <- c(AR1noise.fnc(c(1), sigma, nscan, rho, verbose=verbose))
		}
		if(temp=="state-space"){
			stop("State-space temporal noise model is not yet implemented.")
		}
	}
	if(noise=="low-frequency"){
		n <- c(lowfreq.fnc(c(1), lowfreq, nscan=nscan, TR=TR, verbose=verbose))
	}
	if(noise=="physiological"){
		n <- c(physnoise.fnc(c(1), sigma, nscan, TR, heartfreq, respfreq, verbose=verbose))
	}
	if(noise=="task-related"){
		n <- c(tasknoise.fnc(c(1), act, sigma))
	}
	if(noise=="mixture"){
		if(weights[1]==0){
			n.white <- 0
		} else {
			n.white <- c(gaussnoise.fnc(c(1), sigma, nscan, verbose=verbose))
		}
		if(weights[2]==0){
			n.temp <- 0
		} else {
                	if(temp=="AR(1)"){
                        	n.temp <- c(AR1noise.fnc(c(1), sigma, nscan, rho, verbose=verbose))
                	}
                	if(temp=="state-space"){
                        	stop("State-space temporal noise model is not yet implemented.")
                	}
		}
		if(weights[3]==0){
			n.low <- 0
		} else {
			n.low <- c(lowfreq.fnc(c(1), lowfreq, nscan=nscan, TR=TR, verbose=verbose))
		}
		if(weights[4]==0){
			n.phys <- 0
		} else {
			n.phys <- c(physnoise.fnc(c(1), sigma, nscan, TR, heartfreq, respfreq, verbose=verbose))
		}
		if(weights[5]==0){
			n.task <- 0
		} else {
			n.task <- c(tasknoise.fnc(c(1), act, sigma))
		}
		w <- weights
		n <- w[1]* n.white + w[2]*n.temp + w[3]*n.low + w[4]*n.phys + w[5]*n.task
	}

	fmri.ts <- act + n
	return(fmri.ts)
}

