% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impact.R
\name{impact}
\alias{impact}
\title{Network Impact (combined function)}
\usage{
impact(input, gamma, nodes = c("all"), binary.data = FALSE,
  weighted = TRUE, split = c("median", "mean", "forceEqual", "quartiles"))
}
\arguments{
\item{input}{a matrix or data frame of observations (not a network/edgelist).
See included example datasets \code{\link{depression}} and \code{\link{social}}.}

\item{gamma}{the sparsity parameter used in generating networks. Defaults to 0.5 for interval data
and 0.25 for binary data}

\item{nodes}{indicates which nodes should be tested. Can be given
as a character string of desired nodes (e.g., c("node1","node2")) or as a numeric vector of
column numbers (e.g., c(1,2)).}

\item{binary.data}{logical. Indicates whether the input data is binary}

\item{weighted}{logical. Indicates whether resultant networks preserve edge weights or binarize edges.}

\item{split}{method by which to split network given non-binary data. "median": median split (excluding the median),
"mean": mean split, "forceEqual": creates equally sized groups by partitioning median observations
 to the smaller group, "quartile": uses the top and bottom quartile as groups}
}
\value{
\code{\link{impact}} returns a list of class "\code{all.impact}" which contains:

1. A list of class "global.impact"

2. A list of class "structure.impact"

3. A list of class "edge.impact"

See \code{\link{global.impact}}, \code{\link{structure.impact}}, and \code{\link{edge.impact}} for
details on each list
}
\description{
Generates the global strength impact, network structure
impact, and edge impact simultaneously for a given set of nodes.
See \code{\link{global.impact}}, \code{\link{structure.impact}}, and \code{\link{edge.impact}} for
additional details
}
\details{
The structures of networks sometimes vary as a function of certain external variables.
For instance, Pe et al. (2015) found that the structure of mood networks varied
as a function of whether or not individuals had been diagnosed with major depression.

The structures of networks may also vary as a function of \emph{internal} variables;
that is to say, as a function of each node. \strong{\emph{Impact statistics measure the degree to which
node levels impact network structure.}} Impact statistics are similar to centrality statistics
in the sense that they are a property of each node in a network.

Three relevant impact statistics are included
in the \code{networktools} package: global strength impact, network structure
impact, and edge impact. To ease computational burden, all three statistics are calculated
simultaneously in the \code{\link{impact}} function. They can also be calculated separately
using \code{\link{global.impact}}, \code{\link{structure.impact}}, and \code{\link{edge.impact}}.

Impact statistics are calculated by temporarily regarding a node as an \emph{external} variable
to the network. The remaining data are then divided into two networks according to a median
split (default) on the external node. Network invariance measures are then computed on the two networks.
While median splits are not advisable when continuous analyses are possible, it is not possible
to compute networks in a continuous fashion.
The median split excludes observations that fall exactly on the median. In the case of binary data, data are split
by level rather than by median.
}
\examples{
out <- impact(depression[,1:3])
\donttest{
out1 <- impact(depression)
out2 <- impact(depression, gamma=0.65, nodes=c("sleep_disturbance", "psychomotor_retardation"))
out3 <- impact(social, binary.data=TRUE)
out4 <- impact(social, nodes=c(1:6, 9), binary.data=TRUE)

summary(out1)
plot(out1)

# Extract the impact of psychomotor_retardation on the
# edge that runs between worthlessness and fatigue
out1$Edge$impact[["psychomotor_retardation"]]["worthlessness", "fatigue"]
}
}
