% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dendroNetwork.R, R/diagonalNetwork.R, R/forceNetwork.R, R/networkD3.R, R/radialNetwork.R, R/sankeyNetwork.R, R/simpleNetwork.R
\name{dendroNetworkOutput}
\alias{dendroNetworkOutput}
\alias{diagonalNetworkOutput}
\alias{forceNetworkOutput}
\alias{networkD3-shiny}
\alias{radialNetworkOutput}
\alias{renderDendroNetwork}
\alias{renderDiagonalNetwork}
\alias{renderForceNetwork}
\alias{renderRadialNetwork}
\alias{renderSankeyNetwork}
\alias{renderSimpleNetwork}
\alias{sankeyNetworkOutput}
\alias{simpleNetworkOutput}
\title{Shiny bindings for networkD3 widgets}
\usage{
dendroNetworkOutput(outputId, width = "100\%", height = "800px")

renderDendroNetwork(expr, env = parent.frame(), quoted = FALSE)

diagonalNetworkOutput(outputId, width = "100\%", height = "800px")

renderDiagonalNetwork(expr, env = parent.frame(), quoted = FALSE)

forceNetworkOutput(outputId, width = "100\%", height = "500px")

renderForceNetwork(expr, env = parent.frame(), quoted = FALSE)

radialNetworkOutput(outputId, width = "100\%", height = "800px")

renderRadialNetwork(expr, env = parent.frame(), quoted = FALSE)

sankeyNetworkOutput(outputId, width = "100\%", height = "500px")

renderSankeyNetwork(expr, env = parent.frame(), quoted = FALSE)

simpleNetworkOutput(outputId, width = "100\%", height = "500px")

renderSimpleNetwork(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width,height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended.}

\item{expr}{An expression that generates a networkD3 graph}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
  is useful if you want to save an expression in a variable.}
}
\description{
Output and render functions for using networkD3 widgets within Shiny
applications and interactive Rmd documents.
}

