% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpar.R
\name{set_gpar}
\alias{set_gpar}
\alias{set_edge_gpar}
\alias{set_vertex_gpar}
\alias{get_vertex_gpar}
\alias{get_edge_gpar}
\alias{get_gpar}
\title{Set/retrieve graphical parameters of a \code{netplot} object}
\usage{
set_gpar(x, type, element, idx, ...)

set_edge_gpar(x, element, idx, ...)

set_vertex_gpar(x, element, idx, ...)

get_vertex_gpar(x, element, ..., idx)

get_edge_gpar(x, element, ..., idx)

get_gpar(x, type, element, ..., idx, simplify = TRUE)
}
\arguments{
\item{x}{An object of class \code{netplot}.}

\item{type}{Character. Either \code{"edge"} or \code{"vertex"}.}

\item{element}{Character. If \code{"edge"}, then it can be either \code{"line"} or
\code{"arrow"}, otherwise it can be either \code{"core"} or \code{"frame"}.}

\item{idx}{(optional) Integer vector. Indices of the elements to be modified.
When missing, all elements are modified.}

\item{...}{Parameters to be modified/retrieved. This is passed to \link[grid:grid.edit]{grid::editGrob}
via \link[grid:gpar]{grid::gpar}.}

\item{simplify}{Logical. When \code{TRUE} it tries to simplify the result.
Otherwise it returns a nested list.}
}
\value{
An object of class \code{netplot} with modified parameters.
}
\description{
Set/retrieve graphical parameters of a \code{netplot} object
}
\details{
\code{set_edge_gpar} and \code{set_vertex_gpar} are shorthands for
\code{set_gpar(type = "edge", ...)} and \code{set_gpar(type = "vertex", ...)}
respectively.

\code{get_edge_gpar} and \code{get_vertex_gpar} are shorthands for
\code{get_gpar(type = "edge", ...)} and \code{get_gpar(type = "vertex", ...)}
respectively.
}
\examples{
library(igraph)
library(netplot)

x <- make_ring(5)

g <- nplot(x)

# Updating edge color
g <- set_edge_gpar(g, col = "gray80")

# Retrieving the color of the vertices (core)
get_vertex_gpar(g, element = "core", "fill", "lwd")

}
