% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_test.R
\name{struct_test}
\alias{struct_test}
\alias{n_rewires}
\alias{c.diffnet_struct_test}
\alias{print.diffnet_struct_test}
\alias{hist.diffnet_struct_test}
\alias{struct_test_asymp}
\title{Structure dependence test}
\usage{
n_rewires(graph, p = c(20L, rep(0.1, nslices(graph) - 1)))

struct_test(graph, statistic, R, rewire.args = list(), ...)

\method{c}{diffnet_struct_test}(..., recursive = FALSE)

\method{print}{diffnet_struct_test}(x, ...)

\method{hist}{diffnet_struct_test}(x,
  main = "Empirical Distribution of Statistic", xlab = expression(Values ~
  of ~ t), breaks = 20, annotated = TRUE, b0 = expression(atop(plain("")
  \%up\% plain("")), t[0]), b = expression(atop(plain("") \%up\% plain("")),
  t[]), ask = TRUE, ...)

struct_test_asymp(graph, Y, statistic_name = "distance", p = 2, ...)
}
\arguments{
\item{graph}{A \code{\link{diffnet}} graph.}

\item{p}{Either a Numeric scalar or vector of length \code{nslices(graph)-1}
with the number of rewires per links.}

\item{statistic}{A function that returns either a scalar or a vector.}

\item{R}{Integer scalar. Number of repetitions.}

\item{rewire.args}{List. Arguments to be passed to \code{\link{rewire_graph}}}

\item{...}{Further arguments passed to the method (see details).}

\item{recursive}{Ignored}

\item{x}{A \code{diffnet_struct_test} class object.}

\item{main}{Character scalar. Title of the histogram.}

\item{xlab}{Character scalar. x-axis label.}

\item{breaks}{Passed to \code{\link{hist}}.}

\item{annotated}{Logical scalar. When TRUE marks the observed data average and the simulated data average.}

\item{b0}{Character scalar. When \code{annotated=TRUE}, label for the value of \code{b0}.}

\item{b}{Character scalar. When \code{annotated=TRUE}, label for the value of \code{b}.}

\item{ask}{Logical scalar. When \code{TRUE}, asks the user to type \code{<Enter>} to see each plot (as
many as statistics where computed).}

\item{Y}{Numeric vector of length \eqn{n}.}

\item{statistic_name}{Character scalar. Name of the metric to compute. Currently
this can be either \code{"distance"},\code{">"},\code{"<"},\code{"=="}, \code{">="},
or \code{"<="}.}
}
\value{
A list of class \code{diffnet_struct_test} containing the following:
\item{graph}{The graph passed to \code{struct_test}.}
\item{p.value}{The resulting p-value of the test (see details).}
\item{t0}{The observed value of the statistic.}
\item{mean_t}{The average value of the statistic applied to the simulated networks.}
\item{R}{Number of simulations.}
\item{statistic}{The function \code{statistic} passed to \code{struct_test}.}
\item{boot}{A \code{boot} class object as return from the call to \code{boot}.}
\item{rewire.args}{The list \code{rewire.args} passed to \code{struct_test}.}
}
\description{
Test whether or not a network estimates can be considered structurally dependent, i.e.
a function of the network structure. By rewiring the graph and calculating
a particular statistic \eqn{t}, the test compares the observed mean of \eqn{t}
against the empirical distribution of it obtained from rewiring the network.
}
\details{
\code{struct_test} computes the test by generating the null distribution using
Monte Carlo simulations (rewiring). \code{struct_test_asymp} computes the
test using an asymptotic approximation. While available, we do not recommend
using the asymptotic approximation since it has not shown good results when
compared to the MC approximation. Furthermore, the asymptotic version has only
been implemented for \code{graph} as static graph.

The output from the \code{hist} method is the same as \code{\link{hist.default}}.

\code{struct_test} is a wrapper for the function \code{\link[boot:boot]{boot}} from the
\pkg{boot} package. Instead of resampling data--vertices or edges--in each iteration the function
rewires the original graph using \code{\link{rewire_graph}} and applies
the function defined by the user in \code{statistic}.

The default values to \code{rewire_graph} via \code{rewire.args} are:
\tabular{ll}{
\code{p}          \tab Number or Integer with default \code{n_rewires(graph)}. \cr
\code{undirected} \tab Logical scalar with default \code{getOption("diffnet.undirected", FALSE)}. \cr
\code{copy.first} \tab Logical scalar with \code{TRUE}. \cr
\code{algorithm}  \tab Character scalar with default \code{"swap"}.
}

In \code{struct_test} \code{\dots} are passed to \code{boot}, otherwise are passed
to the corresponding method (\code{\link{hist}} for instance).

From the \code{print} method, p-value for the null of the statistic been
equal between graph and its rewired versions is computed as follows


\deqn{%
p(\tau)=2\times\min\left(\mbox{Pr}(t\leq\tau), \mbox{Pr}(t\geq\tau)\right) %
}{ %
p(tau) = 2*min[Pr(t<=tau), Pr(t>=tau)] %
}

Where \eqn{\mbox{Pr}\{\cdot\}}{Pr(.)} is approximated using the
Empirical Distribution Function retrieved from the simulations.

For the case of the asymptotic approximation, under the null we have

\deqn{%
\sqrt{n}\left(\hat\beta(Y,G)-\mu_\beta\right)\sim^d\mbox{N}\left(0,\sigma_\beta^2\right)
}{%
sqrt(n)*[mean(beta) - E[beta]]/Var[beta] ~ N(0,1)
}


The test is actually on development by Vega Yon and Valente. A copy of the
working paper can be distributed upon request to \email{g.vegayon@gmail.com}.

The function \code{n_rewires} proposes a vector of number of rewirings that
are performed in each iteration.
}
\examples{
# Creating a random graph
set.seed(881)
diffnet <- rdiffnet(100, 5, seed.graph="small-world")

# Testing structure-dependency of threshold
res <- struct_test(diffnet, function(g) mean(threshold(g), na.rm=TRUE), R=100)
res
hist(res)

# Adding a legend
legend("topright", bty="n",
 legend=c(
   expression(t[0]:~Baseline),
   expression(t:~Rewired~average)
 )
 )

# Concatenating results
c(res, res)

# Running in parallel fashion
\dontrun{
res <- struct_test(diffnet, function(g) mean(threshold(g), na.rm=TRUE), R=100,
ncpus=4, parallel="multicore")
res
hist(res)
}
}
\references{
Vega Yon, George G. and Valente, Thomas W. (On development).

Davidson, R., & MacKinnon, J. G. (2004). Econometric Theory and Methods. New York:
Oxford University Press.
}
\seealso{
Other Functions for inference: \code{\link{bootnet}},
  \code{\link{moran}}
}
\author{
George G. Vega Yon
}
\concept{Functions for inference}
