% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_graph.R
\name{rgraph_ba}
\alias{rgraph_ba}
\alias{scale-free}
\title{Barabasi-Albert model}
\usage{
rgraph_ba(m0 = 1L, m = 1L, t = 10L, graph = NULL)
}
\arguments{
\item{m0}{Integer scalar. Number of initial vertices in the graph.}

\item{m}{Integer scalar. Number of new edges per vertex added.}

\item{t}{Integer scalar. Number of time periods (steps).}

\item{graph}{Any class of accepted graph format (see \code{\link{netdiffuseR-graphs}}).}
}
\value{
If \code{graph} is not provided, a static graph, otherwise an expanded
graph (\code{t} aditional vertices) of the same class as \code{graph}.

The resulting graph will have \code{graph$meta$undirected = FALSE} if it is of
class \code{diffnet} and \code{attr(graph, "undirected")=FALSE} otherwise.
}
\description{
Generates a scale-free random graph based on Bollabas et al. (2001), also know as
\emph{Linearized Chord Diagram} (LCD) which has nice mathematical propoerties.
}
\details{
Based on Ballobás et al. (2001) creates a directed random graph of size
\code{t + m0}. A big difference with B-A model
is that this allows for loops (self/auto edges) and further multiple links,
nevertheless, as \eqn{t} increases, the number of such cases reduces.

By default, the degree of the first \code{m0} vertices is set to be 2 (loops).
When \code{m>1}, as described in the paper, each new link from the new vertex
is added one at a time
\dQuote{counting \sQuote{outward half} of the edge being added as already contributing to the degrees}.
}
\examples{
# Using another graph as a base graph
graph <- rgraph_ba()
graph

graph <- rgraph_ba(graph=graph)
}
\author{
George G. Vega Yon
}
\references{
Bollobás, B´., Riordan, O., Spencer, J., & Tusnády, G. (2001). The degree
sequence of a scale-free random graph process. Random Structures & Algorithms,
18(3), 279–290. \url{http://doi.org/10.1002/rsa.1009}

Albert-László Barabási, & Albert, R. (1999). Emergence of Scaling in Random
Networks. Science, 286(5439), 509–512. \url{http://doi.org/10.1126/science.286.5439.509}

Albert-László Barabási. (2016). Network Science: (1st ed.). Cambridge University Press.
Retrieved from \url{http://barabasi.com/book/network-science}
}
\seealso{
Other simulation functions: \code{\link{rdiffnet}},
  \code{\link{rewire_graph}}, \code{\link{rgraph_er}},
  \code{\link{rgraph_ws}}, \code{\link{ring_lattice}}
}
\concept{
Scale-free random graph

Barabasi-Albert model

Random graph
}
\keyword{distribution}

