% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_DM.R
\name{make_DM}
\alias{make_DM}
\title{Make a Duplication and Mutation Network}
\usage{
make_DM(size, net_kind, divergence, mutation, directed = FALSE)
}
\arguments{
\item{size}{Number of nodes in the network.}

\item{net_kind}{If the network is an adjacency matrix ("matrix") or an edge list ("list").}

\item{divergence}{Probability that the new node loses edges associated with the node it duplicates. Needs to be between zero and one.}

\item{mutation}{Probability that the new node gains edges not associated with the node it duplicates. Needs to be between zero and one.}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix. Defaults to TRUE.}
}
\value{
An adjacency matrix.
}
\description{
Make an already existing network according to the Duplication and Mutation mechanism.
}
\details{
Different from Duplication & Mutation models in that edges can only be lost.
}
\examples{
# Import netcom
library(netcom)

# Network size (number of nodes)
size <- 10

# Divergence parameter
divergence <- 0.237

# Mutation parameter
mutation <- 0.1

# Make network according to the Duplication & Mutation mechanism
make_DM(size = size, net_kind = "matrix", divergence = divergence, mutation = mutation)

}
\references{
Ispolatov, I., Krapivsky, P. L., & Yuryev, A. (2005). Duplication-divergence model of protein interaction network. Physical review E, 71(6), 061911.
}
