% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grow_DM.R
\name{grow_DM}
\alias{grow_DM}
\title{Grow a Duplication and Mutation Network}
\usage{
grow_DM(
  matrix,
  x,
  divergence,
  mutation = 0,
  link = 0,
  connected = FALSE,
  retcon = FALSE,
  directed = TRUE
)
}
\arguments{
\item{matrix}{Existing network to experience growth.}

\item{x}{The ID of the node to be grown.}

\item{divergence}{Probability that the new node loses edges associated with the node it duplicates. Needs to be between zero and one.}

\item{mutation}{Probability that the new node gains edges not associated with the node it duplicates. Needs to be between zero and one.}

\item{link}{Probability that the new node attaches to the node it duplicates. Defaults to 0.}

\item{connected}{Binary argument determining if the newly grown node has to be connected to the existing network. Defaults to FALSE, to prevent rare computational slow-downs when it is unlikely to create a connected network. Defaults to FALSE.}

\item{retcon}{Binary variable determining if already existing nodes can attach to new nodes. Defaults to FALSE.}

\item{directed}{Binary variable determining if the network is directed, resulting in off-diagonal asymmetry in the adjacency matrix. Defaults to TRUE.}
}
\value{
An adjacency matrix.
}
\description{
Grows an already existing network by adding a node according to the Duplication and Mutation mechanism. Nodes can only attach to previously grown nodes.
}
\details{
Different from Duplication & Mutation models in that edges can only be lost.
}
\examples{
# Import netcom
library(netcom)

size <- 10
existing_network <- matrix(sample(c(0,1), size = size^2, replace = TRUE), nrow = size, ncol = size)
new_network_prep <- matrix(0, nrow = size + 1, ncol = size + 1)
new_network_prep[1:size, 1:size] = existing_network
new_network <- grow_DM(matrix = new_network_prep, x = size + 1, divergence = 0.5)

}
\references{
Ispolatov, I., Krapivsky, P. L., & Yuryev, A. (2005). Duplication-divergence model of protein interaction network. Physical review E, 71(6), 061911.
}
