% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_xy.R
\name{fit_xy.nested_model}
\alias{fit_xy.nested_model}
\title{Fit a nested model to a dataset using an xy interface.}
\usage{
\method{fit_xy}{nested_model}(
  object,
  x,
  y,
  case_weights = NULL,
  control = parsnip::control_parsnip(),
  ...
)
}
\arguments{
\item{object}{An \code{nested_model} object (see \code{\link[=nested]{nested()}}).}

\item{x}{A data frame of predictors.}

\item{y}{A data frame of outcome data.}

\item{case_weights}{An optional vector of case weights. Passed into
\code{\link[parsnip:fit]{parsnip::fit.model_spec()}}.}

\item{control}{A \code{\link[parsnip:control_parsnip]{parsnip::control_parsnip()}} object. Passed into
\code{\link[parsnip:fit]{parsnip::fit.model_spec()}}.}

\item{...}{Passed into \code{\link[parsnip:fit]{parsnip::fit.model_spec()}}. Currently unused.}
}
\value{
A \code{nested_model_fit} object with several elements:
\itemize{
\item \code{spec}: The model specification object (the inner model of the
nested model object)
\item \code{fit}: A tibble containing the model fits and the nests that they
correspond to.
\item \code{inner_names}: A character vector of names, used to help with
nesting the data during predictions.
}
}
\description{
\code{\link[generics:fit_xy]{generics::fit_xy()}} method for nested models. This should not be
called directly and instead should be called by
\code{\link[workflows:fit-workflow]{workflows::fit.workflow()}}.
}
\examples{
\dontshow{if (rlang::is_installed("workflows")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

library(dplyr)
library(parsnip)
library(recipes)
library(workflows)

data <- filter(example_nested_data, id \%in\% 11:20)

model <- linear_reg() \%>\%
  set_engine("lm") \%>\%
  nested()

recipe <- recipe(data, z ~ x + y + id) \%>\%
  step_nest(id)

wf <- workflow() \%>\%
  add_recipe(recipe) \%>\%
  add_model(model)

fit(wf, data)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[parsnip:fit]{parsnip::fit.model_spec()}} \link[parsnip:model_fit]{parsnip::model_fit}
}
