% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_classDefinitions.R
\docType{class}
\name{publications_classes}
\alias{publications_classes}
\alias{publication-class}
\alias{publications-class}
\title{An S4 class for Neotoma \code{publications}.}
\value{
object of class \code{publication}
}
\description{
A publication is liked to an individual Neotoma dataset object
They are grouped using an S4 \code{publications} class.
This \code{publications} class allows a single dataset to have one
or more publication classes associated with it.
}
\examples{
{
simon <- new("contact", familyname = "Goring", givennames = "Simon J.")
socorro <- new("contact", familyname = "Dominguez", givennames = "Socorro")
first_author <- new("author", author = simon, order = 1)
second_author <- new("author", author = socorro, order = 2)
author_list <- new("authors", authors = list(first_author, second_author))
pub <- new("publication",
           articletitle = "Top or bottom: Best toast spreading surfaces.",
           journal = "Peanut Butter Science",
           year = "2022",
           volume = "2",
           author = author_list)
           }
}
