% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bind.R
\name{bind}
\alias{bind}
\title{Function to bind objects together into a longer object.}
\usage{
bind(x, ...)
}
\arguments{
\item{x}{An object returned by one of the \code{get_*} commands for download, site or dataset.}

\item{...}{other objects of the same class.}
}
\value{
This command returns a larger list.
}
\description{
From multiple \code{download*}s, \code{dataset*}s or \code{site}s, join them together into a single object.
}
\details{
To support further synthesis and analysis \code{compile_download} works to transform a list
returned by \code{\link{get_download}} into a large data frame with columns for site and sample attributes
and also with the associated assemblage data at each sample depth.  This function also does the same for
single sites.
}
\examples{
\dontrun{
#  Search for sites with "Thuja" pollen that are older than 8kyr BP and
#  that are on the west coast of North America:
t8kyr.poa <- get_dataset(taxonname='Thuja*', loc=c(-150, 20, -100, 60), ageyoung = 8000)
t8kyr.canis <- get_dataset(taxonname='Canis*', loc=c(-150, 20, -100, 60), ageyoung = 8000)

t8kyr.co_site <- bind(t8kyr.poa, t8kyr.canis)

}
}
\author{
Simon J. Goring \email{simon.j.goring@gmail.com}
}
\references{
Neotoma Project Website: http://www.neotomadb.org
}
\keyword{utilities}

