% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_read.R
\name{neon_read}
\alias{neon_read}
\title{read in neon tabular data}
\usage{
neon_read(
  table = NA,
  product = NA,
  site = NA,
  start_date = NA,
  end_date = NA,
  ext = NA,
  timestamp = NA,
  dir = neon_dir(),
  files = NULL,
  sensor_metadata = TRUE,
  ...
)
}
\arguments{
\item{table}{the name of a downloaded NEON table in the store,
see \link{neon_index}}

\item{product}{Include only files matching this NEON productCode(s)}

\item{site}{4-letter site code(s) to filter on. Leave as \code{NA} to search all.}

\item{start_date}{Download only files as recent as (\code{YYYY-MM-DD}). Leave
as \code{NA} to download up to the most recent available data.}

\item{end_date}{Download only files up to end_date (\code{YYYY-MM-DD}). Leave as
\code{NA} to download all prior data.}

\item{ext}{only match files with this file extension(s)}

\item{timestamp}{only match timestamps prior this. See details in \code{\link[=neon_index]{neon_index()}}.
Should be a datetime POSIXct object (or coerce-able string)}

\item{dir}{Location where files should be downloaded. By default will
use the appropriate applications directory for your system
(see \link[rappdirs:user_data_dir]{rappdirs::user_data_dir}).  This default also be configured by
setting the environmental variable \code{NEONSTORE_HOME}, see \link{Sys.setenv} or
\link{Renviron}.}

\item{files}{optionally, specify a vector of file paths directly (e.g. as
provided from \link{neon_index}) and specify \code{table} argument as NULL.}

\item{sensor_metadata}{logical, default TRUE. Should we add
metadata fields from file names of sensor data into the table?  Adds
DomainID, SiteID, horizontalPosition, verticalPosition, and publicationDate.
Results in slower parsing.}

\item{...}{additional arguments to \link[vroom:vroom]{vroom::vroom}, can usually be omitted.}
}
\description{
read in neon tabular data
}
\details{
NEON's tabular data files are separated out into separate .csv
files for each site for each month of sampling.  In principle,
each file has identical columns.  \link[vroom:vroom]{vroom::vroom} can read in a
data table that has been sharded into many files like this much
much faster than other parsers can read in each table iteratively,
(and thus can greatly out-perform the 'stacking" methods in \code{neonUtilities}).

When reading in very large numbers of files, it may be helpful to set
\code{altrep = FALSE} to opt out of \code{vroom}'s fast altrep mechanism, which
can cause \code{\link[=neon_read]{neon_read()}} to fail when stacking thousands of files.

Unfortunately, not all datasets are entirely consistent in their use
of columns.  \code{neon_read} works around this by parsing such tables in
groups of matching schema, which is still reasonably fast.

NEON sensor data products currently do not include important metadata columns
containing DomainID, SiteID, horizontalPosition, verticalPosition, and
publicationDate in the data files themselves, but only encode this in the
in the raw file names. All though these values are shared across a raw
data file, this information is lost when stacking the tables unless explicit
columns are added to the data.  This requires us to parse the files
one-by-one, which is much slower.  By default this information is added to
the table, altering the stacked table schema from that of the raw table.
Disable this behavior by setting \code{sensor_metadata = FALSE}.  Future
NEON sensor data products may start including this information in
the raw data files, as is already the case for observational data.
}
\examples{

neon_read("brd_countdata-expanded")

## Read in specific files from the neon_index():
files <- neon_index(table = "brd_countdata-expanded")$path
neon_read(files = files)

## Sensor inputs will add metadata columns by default
neon_read("waq_instantaneous", site = c("CRAM","SUGG"))


}
