% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acquire_neon_data.R
\name{acquire_neon_data}
\alias{acquire_neon_data}
\title{Acquire NEON data for processing}
\usage{
acquire_neon_data(
  site_name,
  download_date,
  time_frequency = "30_minute",
  provisional = FALSE
)
}
\arguments{
\item{site_name}{Required. NEON code for a particular site (a string)}

\item{download_date}{Required. Date where we end getting NEON data. Format: YYYY-MM (can't specify day).  So "2020-05" means it will grab data for the entire 5th month of 2020. (a string). Downloads data for a given month only}

\item{time_frequency}{Required. Will you be using 30 minute ("30_minute") or 1 minute ("1_minute") recorded data? Defaults to 30 minutes.}

\item{provisional}{Required. Should you use provisional data when downloading? Defaults to FALSE. See \href{https://www.neonscience.org/data-samples/data-management/data-revisions-releases}{NEON Data Releases}. Defaults to FALSE (similar to include.provisional in \link[neonUtilities]{loadByProduct}).}
}
\value{
A list containing stacked environmental data (`site_data`) and soil properties (`site_megapit`).
}
\description{
Given a site code and dates, apply the neonUtilities package to download the data from NEON API
}
\examples{
\donttest{
out_env_data <- acquire_neon_data("SJER","2022-06")
}
}
\author{
John Zobitz \email{zobitz@augsburg.edu}
}
