% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/safety_04.R
\name{safety_04}
\alias{safety_04}
\title{Safety-04 Calculation}
\usage{
safety_04(
  df = NULL,
  patient_scene_table = NULL,
  response_table = NULL,
  arrest_table = NULL,
  injury_table = NULL,
  procedures_table = NULL,
  disposition_table = NULL,
  erecord_01_col,
  incident_date_col = NULL,
  patient_DOB_col = NULL,
  epatient_15_col,
  epatient_16_col,
  eresponse_05_col,
  earrest_01_col,
  einjury_03_col,
  eprocedures_03_col,
  edisposition_14_col,
  transport_disposition_col,
  ...
)
}
\arguments{
\item{df}{A data frame or tibble containing EMS data where each row
represents an individual observation.}

\item{patient_scene_table}{A data frame or tibble containing fields from
epatient and escene needed for this measure's calculations.}

\item{response_table}{A data frame or tibble containing fields from eresponse
needed for this measure's calculations.}

\item{arrest_table}{A data frame or tibble containing fields from earrest
needed for this measure's calculations.}

\item{injury_table}{A data frame or tibble containing fields from einjury
needed for this measure's calculations.}

\item{procedures_table}{A data frame or tibble containing fields from
eprocedures needed for this measure's calculations.}

\item{disposition_table}{A data frame or tibble containing fields from
edisposition needed for this measure's calculations.}

\item{erecord_01_col}{The column containing unique record identifiers for
each encounter.}

\item{incident_date_col}{Column that contains the incident date. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{patient_DOB_col}{Column that contains the patient's date of birth. This
defaults to \code{NULL} as it is optional in case not available due to PII
restrictions.}

\item{epatient_15_col}{Column name indicating the patient age.}

\item{epatient_16_col}{Column name for the unit of age (e.g., "Years,"
"Months").}

\item{eresponse_05_col}{Column containing response transport codes.}

\item{earrest_01_col}{Column with cardiac arrest status information.}

\item{einjury_03_col}{Column describing traumatic injuries, expected as a
list or text-separated entries.}

\item{eprocedures_03_col}{Column listing procedures, assumed to contain
multiple procedure codes/texts in each cell.}

\item{edisposition_14_col}{Column for transport dispositions.}

\item{transport_disposition_col}{Columns for primary and secondary transport
dispositions.}

\item{...}{Additional arguments for flexibility in function customization.}
}
\value{
A data.frame summarizing results for three population groups (All,
Adults, and Peds) with the following columns:

\code{measure}: The name of the measure being calculated.
\code{pop}: Population type (All, Adults, or Peds).
\code{numerator}: Count of incidents where beta-agonist medications were
administered.
\code{denominator}: Total count of incidents.
\code{prop}: Proportion of incidents involving beta-agonist medications.
\code{prop_label}: Proportion formatted as a percentage with a specified number
of decimal places.
}
\description{
The \code{safety_04} function processes EMS incident data for specific safety and
transport criteria, filtering by patient age and incident type to identify
cases that meet specified exclusion or inclusion criteria. This function
accommodates data with various EMS-specific codes, age descriptors, and
procedure identifiers.
}
\examples{

# Synthetic test data
  test_data <- tibble::tibble(
    erecord_01 = c("R1", "R2", "R3", "R4", "R5"),
    epatient_15 = c(34, 5, 45, 2, 60),  # Ages
    epatient_16 = c("Years", "Years", "Years", "Months", "Years"),
    eresponse_05 = rep(2205001, 5),
    earrest_01 = rep("No", 5),
    einjury_03 = rep("non-injury", 5),
    edisposition_14 = rep(4214001, 5),
    edisposition_30 = rep(4230001, 5),
    eprocedures_03 = rep("other response", 5)
  )

  # Run function
  safety_04(
    df = test_data,
    erecord_01_col = erecord_01,
    epatient_15_col = epatient_15,
    epatient_16_col = epatient_16,
    eresponse_05_col = eresponse_05,
    earrest_01_col = earrest_01,
    einjury_03_col = einjury_03,
    edisposition_14_col = edisposition_14,
    transport_disposition_col = edisposition_30,
    eprocedures_03_col = eprocedures_03
  )

}
\author{
Nicolas Foss, Ed.D., MS
}
