% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/natstrat-package.R
\docType{package}
\name{natstrat-package}
\alias{natstrat}
\alias{natstrat-package}
\title{natstrat: Obtain Unweighted Natural Strata that Balance Many Covariates}
\description{
Natural strata fix a constant ratio of controls to treated units within
each stratum. This ratio need not be an integer. The control units are
chosen using randomized rounding of a linear program that balances many
covariates.
To solve the linear program, the 'Gurobi' commercial optimization software
is recommended, but not required. The 'gurobi' R package can be installed following
the instructions \href{https://www.gurobi.com/documentation/9.1/refman/ins_the_r_package.html}{here}.
}
\details{
To achieve the desired ratio of control to treated units,
a subset of control units are
chosen using by optimizing the balance of many covariates using
either randomized rounding of a linear program or
an integer program. The main function in this package is \code{\link{optimize_controls}()}.
To create the input constraints for this function, you should use
\code{\link{generate_constraints}()}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/kkbrum/natstrat}
  \item \url{https://kkbrum.github.io/natstrat/}
  \item \url{https://www.gurobi.com/documentation/9.1/refman/ins_the_r_package.html}
  \item Report bugs at \url{https://github.com/kkbrum/natstrat/issues}
}

}
\author{
\strong{Maintainer}: Katherine Brumberg \email{kbrum@wharton.upenn.edu}

}
\keyword{internal}
