% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_qs.R
\name{generate_qs}
\alias{generate_qs}
\title{Calculate desired number of controls per stratum}
\usage{
generate_qs(
  z,
  st,
  ratio,
  treated = 1,
  max_ratio = NULL,
  max_extra_s = 5,
  strata_dist = NULL
)
}
\arguments{
\item{z}{a factor with the \code{i}th entry equal to the treatment of unit \code{i}.}

\item{st}{a stratum vector with the \code{i}th entry equal to the
stratum of unit \code{i}. This should have the same order of units and length
as \code{z}.}

\item{ratio}{a numeric or vector specifying the desired ratio of controls to `treated` in
each stratum. If there is one control group and all treated units should be included,
this can be a numeric. Otherwise, this should be
a vector with one entry per treatment group, in the same order as the levels of
\code{z}, including the treated level. If \code{NULL}, \code{q_s} should be specified.}

\item{treated}{which treatment value should be considered the treated units. This
must be one of the values of \code{z}.}

\item{max_ratio}{a numeric or vector specifying the maximum ratio to allow in a stratum to achieve
the overall \code{ratio} specified. If \code{NULL}, it is set by default to 1.1 times the desired \code{ratio}.
To have no maximum ratio, set this to \code{Inf}.}

\item{max_extra_s}{single numeric or named vector or matrix with values corresponding to the maximum desired number
of extra controls to be chosen from each stratum to achieve the overall
\code{ratio} specified. If this is a vector, the names should correspond to the stratum
values from \code{st}. If there are more than two treatment levels,
this should be a matrix with one row per treatment level, in the same
order as the levels of \code{z}. The default is 5 for each stratum in each treatment group.
To have no maximum, set this to \code{Inf}.
If both \code{max_ratio} and \code{max_s} are specified, the
maximum of the two will be used for each stratum.}

\item{strata_dist}{matrix with both row and column names with names corresponding
to the stratum values from \code{st} and entries corresponding to the distance
associated with taking a control from the stratum associated with the row when
the desired stratum is the one associated with the column. Lower distance values
are more desirable replacements. Typically the diagonal should be 0, meaning
there is no penalty for choosing a unit from the correct stratum.}
}
\value{
A named vector stating how many controls to take from each stratum.
}
\description{
Figure out how many units to take from each stratum when some strata are deficient.
The result should be used as an input to \code{\link{optimize_controls}()}.
}
