% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R, R/zzz.R
\name{install}
\alias{install}
\alias{check_pat}
\title{Install natverse packages from GitHub}
\usage{
install(
  collection = c("core", "natverse"),
  pkgs = NULL,
  dependencies = TRUE,
  upgrade.dependencies = "always",
  ...
)

check_pat(create = TRUE)
}
\arguments{
\item{collection}{The collection of natverse packages that you would like to
install. The current options are \code{core}, the default, or
\code{natverse}. See Description for more information.}

\item{pkgs}{A character vector of package names specifying natverse packages
to install. When present overrides the \code{collection} argument.}

\item{dependencies}{Which dependencies you want to install see
\code{\link[remotes]{install_github}}.}

\item{upgrade.dependencies}{Whether to install dependencies of natmanager.
See the \code{upgrade} argument of \code{\link[remotes]{install_github}}
for details. The default will go ahead and always do this is as necessary.}

\item{...}{extra arguments to pass to \code{\link[remotes]{install_github}}.}

\item{create}{Whether to help you create a personal GITHUB_PAT if you do not
have one set. When \code{create=FALSE} a default PAT will be used if you
have not set your own. This could cause trouble if other people are using
the same PAT.}
}
\value{
\code{check_pat} returns the PAT invisibly or errors out if
  \code{create=TRUE} and none can be set.
}
\description{
\code{install} allows you to install one of two collections of
  nat packages

  \itemize{

  \item \code{core} a minimal install that can help users to get started with
  nat and already solve many problems (the default)

  \item \code{natverse} a powerful "batteries included" distribution with all
  mature packages in the natverse.

  }

  Since the \code{natverse} option will install many packages from GitHub,
  you need to have a GitHub account and personal access token (GITHUB_PAT).
  Install will check to see if you have a \code{GITHUB_PAT} already and, if
  not, walk you through the steps of setting one up. A fall-back PAT is built
  into the package but we strongly recommend that you sign up to GitHub and
  get your own if you start using the natverse regularly.

\code{check_pat} can be used to check if you have a GITHUB_PAT
  set and will advise on how to do this if necessary.
}
\examples{
\dontrun{
# install core packages to try out the core natverse
natmanager::install('core')

# Full "batteries included" installation with all packages
natmanager::install('natverse')

# Install natverse, non-natverse package
# for natverse packages no need to specify the repo
natmanager::install(pkgs=c('nat.jrcbrains','flyconnectome/hemibrainr'))
}
\dontrun{
# Check status of GitHub PAT and create one if required
natmanager::check_pat(create=TRUE)
# Check status of GitHub PAT and use default if no personal one available
natmanager::check_pat(create=FALSE)
}
}
