% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuriteblast.r
\name{NeuriteBlast}
\alias{NeuriteBlast}
\title{Produce similarity score for neuron morphologies}
\usage{
NeuriteBlast(
  query,
  target,
  targetBinds = NULL,
  normalised = FALSE,
  OmitFailures = NA,
  simplify = TRUE,
  ...
)
}
\arguments{
\item{query}{either a single query neuron or a \code{\link[nat]{neuronlist}}}

\item{target}{a \code{neuronlist} to compare neuron against.}

\item{targetBinds}{numeric indices or names with which to subset
\code{target}.}

\item{normalised}{whether to divide scores by the self-match score of the
query}

\item{OmitFailures}{Whether to omit neurons for which \code{FUN} gives an
error. The default value (\code{NA}) will result in \code{nblast} stopping
with an error message the moment there is an error. For other values, see
details.}

\item{simplify}{whether to simplify the scores from a list to a vector.
\code{TRUE} by default. The only time you might want to set this false is
if you are collecting something other than simple scores from the search
function. See \code{\link{simplify2array}} for further details.}

\item{...}{extra arguments to pass to the distance function.}
}
\value{
Named list of similarity scores.
}
\description{
A low-level entry point to the NBLAST algorithm that compares the morphology
of a neuron with those of a list of other neurons. For most use cases, one
would probably wish to use \code{\link{nblast}} instead.
}
\details{
For detailed description of the \code{OmitFailures} argument, see
  the details section of \code{\link{nblast}}.
}
\seealso{
\code{\link{WeightedNNBasedLinesetMatching}}
}
