% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoival.R
\name{seq,nanoival-method}
\alias{seq,nanoival-method}
\title{Sequence Generation}
\usage{
\S4method{seq}{nanoival}(from, to = NULL, by = NULL, length.out = NULL, along.with = NULL, ...)
}
\arguments{
\item{from, to}{the starting and (maximal) end values of the
sequence}

\item{by}{\code{nanoduration} or \code{nanoperiod} increment of
the sequence; note that if the class is \code{nanoperiod} the
additional argument \code{tz} must be speficied and is of
\code{character} type indicating a timezone}

\item{length.out}{an integer desired length of the sequence}

\item{along.with}{take the length from the length of this argument.}

\item{...}{arguments passed to or from methods; the only
interesting additional argument is \code{tz} where the
\code{to} argument is of type \code{nanoperiod}}
}
\description{
Generate a sequence of \code{nanoival}
}
\examples{
from <- as.nanoival("-2018-01-14T13:00:00+00:00 -> 2018-01-14T15:00:00+00:00+")
seq(from, by=as.nanoperiod("1m"), length.out=5, tz="America/New_York")
}
