% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messenger.R
\name{messenger}
\alias{messenger}
\title{Messenger}
\usage{
messenger(url, auth = NULL)
}
\arguments{
\item{url}{a URL to connect to, specifying the transport and address as
a character string e.g. 'tcp://127.0.0.1:5555' (see \link{transports}).}

\item{auth}{[default NULL] an R object (possessed by both parties) which
serves as a pre-shared key on which to authenticate the communication.
Note: the object is never sent, only a random subset of its SHA256 hash.}
}
\value{
Invisible NULL.
}
\description{
Multi-threaded, console-based, 2-way instant messaging system with
    authentication, based on NNG scalability protocols.
}
\section{Usage}{


    Type outgoing messages and hit return to send.

    The timestamps of outgoing messages are prefixed by \code{>} and that of
    incoming messages by \code{<}.

    \code{:q} is the command to quit.

    Both parties must supply the same argument for 'auth', otherwise the
    party trying to connect will receive an 'authentication error' and be
    disconnected immediately.

    NOTE: This is currently a proof of concept with an experimental
    authentication protocol and should not be used for critical applications.
}

