% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ncurl.R
\name{ncurl_aio}
\alias{ncurl_aio}
\title{ncurl Async}
\usage{
ncurl_aio(
  url,
  convert = TRUE,
  method = NULL,
  headers = NULL,
  data = NULL,
  response = NULL,
  timeout = NULL,
  tls = NULL
)
}
\arguments{
\item{url}{the URL address.}

\item{convert}{[default TRUE] logical value whether to attempt conversion of
the received raw bytes to a character vector. Set to FALSE if downloading
non-text data.}

\item{method}{(optional) the HTTP method (defaults to 'GET' if not specified).}

\item{headers}{(optional) a named list or character vector specifying the
HTTP request headers e.g. \code{list(`Content-Type` = "text/plain")} or
\code{c(Authorization = "Bearer APIKEY")}. Supplying a non-named list or
vector will error.}

\item{data}{(optional) the request data to be submitted.}

\item{response}{(optional) a character vector or list specifying the response
headers to return e.g. \code{c("date", "server")} or \code{list("Date", "Server")}.
These are case-insensitive and will return NULL if not present.}

\item{timeout}{(optional) integer value in milliseconds after which the
transaction times out if not yet complete.}

\item{tls}{(optional) applicable to secure HTTPS sites only, a client TLS
Configuration object created by \code{\link{tls_config}}. If missing or
NULL, certificates are not validated.}
}
\value{
An 'ncurlAio' (object of class 'ncurlAio' and 'recvAio') (invisibly).
    The following elements may be accessed:
    \itemize{
    \item{\code{$status}} {- integer HTTP repsonse status code (200 - OK).
    Use \code{\link{status_code}} for a translation of the meaning.}
    \item{\code{$headers}} {- named list of response headers supplied in
    'response', or NULL otherwise. If the status code is within the 300
    range, i.e. a redirect, the response header 'Location' is automatically
    appended to return the redirect address.}
    \item{\code{$data}} {- the response body, as a character string if
    'convert' = TRUE (may be further parsed as html, json, xml etc. as
    required), or a raw byte vector if FALSE (use \code{\link{writeBin}} to
    save as a file).}
    }
}
\description{
nano cURL - a minimalist http(s) client - async edition.
}
\examples{
nc <- ncurl_aio("https://www.r-project.org/",
                response = c("date", "server"),
                timeout = 2000L)
call_aio(nc)
nc$status
nc$headers
nc$data

}
\seealso{
\code{\link{ncurl_session}} for persistent connections.
}
