% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{WriteIntImage}
\alias{WriteIntImage}
\title{Write an integer array to disk as a tiff image.}
\usage{
WriteIntImage(img.arr, file.name, na = "error")
}
\arguments{
\item{img.arr}{An integer array.}

\item{file.name}{The name of the tif file (with or without the .tif) that you
wish to write.}

\item{na}{How do you want to treat \code{NA} values? R can only write integer
values (and hence not \code{NA}s) to tiff pixels. \code{na = 'saturate'} sets them to
saturated value. \code{na = 'zero'} sets them to zero, while \code{na = 'error'} will
give an error if the image contains \code{NA}s. You can also specify directly
here a natural number (must be between 0 and 2 ^ 16 - 1) to use in place of
\code{NA}s.}
}
\description{
\link[EBImage:writeImage]{EBImage::writeImage} truncates all values above 1 to 1 and all below 0 to 0
when writing images. This function allows you to write integer-vlued arrays
to disk as tiff files as you would want.
}
\examples{
img <- ReadImageData(system.file('extdata', '50.tif', package = 'nandb'))
setwd(tempdir())
WriteIntImage(img, '50.tif')
file.remove(list.files())  # cleanup

}
