% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R, R/naive.R
\docType{package}
\name{naive}
\alias{naive}
\alias{naive-package}
\title{naive}
\usage{
naive(
  df,
  seq_len = NULL,
  ci = 0.8,
  smoother = FALSE,
  cover = NULL,
  stride = NULL,
  method = NULL,
  location = NULL,
  n_windows = 10,
  n_samp = 30,
  dates = NULL,
  error_scale = "naive",
  error_benchmark = "naive",
  seed = 42
)
}
\arguments{
\item{df}{A data frame with time features on columns (all numerics or all categories, but not both). In case of missing values, automatic missing imputation through kalman filter will be performed.}

\item{seq_len}{Positive integer. Time-step number of the forecasting sequence. Default: NULL (random selection within boundaries).}

\item{ci}{Confidence interval for prediction. Default: 0.8}

\item{smoother}{Logical. Flag to TRUE for loess smoothing (only for numeric series). Default: FALSE.}

\item{cover}{Positive numeric. The quantile cover around the location parameter (between 0 and 1). Default: NULL (random selection within boundaries).}

\item{stride}{Positive integer. Shift between subsequent sequences. Default: NULL (random selection within boundaries).}

\item{method}{String. Distance method using during the comparison of time sequences. Possible options are: "euclidean", "manhattan", "minkowski". Default: NULL (random selection).}

\item{location}{String. Statistic used to center the cover parameter. Possible options are: "mean", "mode" (parzen method), "median". Default: NULL (random selection).}

\item{n_windows}{Positive integer. Number of validation windows to test prediction error. Default: 10.}

\item{n_samp}{Positive integer. Number of sample selected during random search. Default: 30.}

\item{dates}{Date. Vector with dates for time features.}

\item{error_scale}{String. Scale for the scaled error metrics. Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics. Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}

\item{seed}{Positive integer. Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item exploration: collection of all the models explored with random search
\item history: a table with the explored models' hyper-parameters and validation errors
\item best_model: best combination resulting from the average prediction score across different ranks and features, including:
\itemize{
\item quant_preds: min, max, q25, q50, q75, quantiles at selected ci, mean, sd, mode, skewness, kurtosis, IQR to range, above to below median range, upside probability and divergence for each point fo predicted sequences
\item errors: testing errors for each time feature averaged across validation windows
\item plots: standard plot with confidence interval for each time feature
}
\item time_log
}
}
\description{
Empirical Extrapolation of Time Feature Pattern
}
\examples{
{
naive(time_features[, 2:3, drop = FALSE], seq_len = 30, n_samp = 1, n_windows = 5)
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/naive}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}

\strong{Maintainer}: Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com} [copyright holder]

}
