% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSelectedAgeDistr.R
\name{PlotSelectedAgeDistr}
\alias{PlotSelectedAgeDistr}
\title{Plot the PS or DS distribution of a selected set of genes}
\usage{
PlotSelectedAgeDistr(ExpressionSet, gene.set, legendName = NULL,
  as.ratio = FALSE, use.only.map = FALSE, col = "turquoise4",
  xlab = NULL, ylab = NULL)
}
\arguments{
\item{ExpressionSet}{a standard PhyloExpressionSet or DivergenceExpressionSet object.}

\item{gene.set}{a character vector storing the gene ids for which gene expression profiles shall be visualized.}

\item{legendName}{a character string specifying whether "PS" or "DS" are are visualized.}

\item{as.ratio}{logical value indicating whether or not relative frequencies shall be visualized.}

\item{use.only.map}{logical value indicating whether or not a Phylostratigraphic Map or Divergence Map should be passed to the \code{ExpressionSet} argument instead of a standard \code{ExpressionSet} object.}

\item{col}{colour of the bars.}

\item{xlab}{label of the x-axis.}

\item{ylab}{label of the y-axis.}
}
\description{
This function visualizes the PS or DS distribution of a selected set of genes
as histogram.
}
\examples{
data(PhyloExpressionSetExample)

# generate an example gene set
set.seed(123)
ExGeneSet <- sample(PhyloExpressionSetExample[ , 2], 5000)

# gene count example
PlotSelectedAgeDistr(ExpressionSet = PhyloExpressionSetExample,
                     gene.set      = ExGeneSet,
                     legendName    = "PS",
                     as.ratio      = TRUE)

# relative gene count example
PlotSelectedAgeDistr(ExpressionSet = PhyloExpressionSetExample,
                     gene.set      = ExGeneSet,
                     legendName    = "PS",
                     as.ratio      = FALSE)

}
\author{
Hajk-Georg Drost
}
\seealso{
\code{\link{PlotDistribution}}
}

