/*
 * Decompiled with CFR 0.152.
 */
package ru.itmo.ctlab.virgo.sgmwcs.solver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.itmo.ctlab.virgo.Pair;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Edge;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Graph;
import ru.itmo.ctlab.virgo.sgmwcs.graph.Node;
import ru.itmo.ctlab.virgo.sgmwcs.graph.flow.EdmondsKarp;
import ru.itmo.ctlab.virgo.sgmwcs.graph.flow.MaxFlow;

public class CutGenerator {
    private MaxFlow maxFlow;
    private Map<Node, Integer> nodes;
    private Node root;
    private Map<Edge, Pair<Integer, Integer>> edges;
    private List<Node> backLink;
    private Map<Node, Double> weights;
    private Graph graph;

    public CutGenerator(Graph graph, Node root) {
        int i = 0;
        this.weights = new HashMap<Node, Double>();
        this.backLink = new ArrayList<Node>();
        this.nodes = new HashMap<Node, Integer>();
        this.edges = new HashMap<Edge, Pair<Integer, Integer>>();
        for (Node node : graph.vertexSet()) {
            this.nodes.put(node, i++);
            this.backLink.add(node);
        }
        this.maxFlow = new EdmondsKarp(graph.vertexSet().size());
        for (Edge e : graph.edgeSet()) {
            Node v = graph.getEdgeSource(e);
            Node u = graph.getEdgeTarget(e);
            this.maxFlow.addEdge(this.nodes.get(v), this.nodes.get(u));
            this.edges.put(e, new Pair<Integer, Integer>(this.nodes.get(v), this.nodes.get(u)));
        }
        this.root = root;
        this.graph = graph;
    }

    public void setCapacity(Edge e, double capacity) {
        Pair<Integer, Integer> edge = this.edges.get(e);
        this.maxFlow.setCapacity((Integer)edge.first, (Integer)edge.second, capacity);
        this.maxFlow.setCapacity((Integer)edge.second, (Integer)edge.first, capacity);
    }

    public void setVertexCapacity(Node v, double capacity) {
        this.weights.put(v, capacity);
    }

    public List<Edge> findCut(Node v) {
        List<Pair<Integer, Integer>> cut = this.maxFlow.computeMinCut(this.nodes.get(this.root), this.nodes.get(v), this.weights.get(v));
        if (cut == null) {
            return null;
        }
        ArrayList<Edge> result = new ArrayList<Edge>();
        for (Pair<Integer, Integer> p : cut) {
            result.addAll(this.graph.getAllEdges(this.backLink.get((Integer)p.first), this.backLink.get((Integer)p.second)));
        }
        return result;
    }

    public Set<Node> getNodes() {
        return this.nodes.keySet();
    }

    public Set<Edge> getEdges() {
        return this.edges.keySet();
    }

    public Node getRoot() {
        return this.root;
    }
}

