% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmvss.R
\name{rmvss}
\alias{rmvss}
\title{Multivariate Subgaussian Stable Random Variates}
\usage{
rmvss(
  n,
  alpha = 1,
  Q = NULL,
  delta = rep(0, d),
  which.stable = c("libstableR", "stabledist")[1]
)
}
\arguments{
\item{n}{number of observations}

\item{alpha}{default to 1 (Cauchy). Must be 0<alpha<2}

\item{Q}{Shape matrix.  See Nolan (2013).}

\item{delta}{location vector.}

\item{which.stable}{defaults to "libstableR", other option is "stabledist".  Indicates which package
should provide the univariate stable distribution in this production distribution form of a univariate
stable and multivariate normal.}
}
\value{
Returns the \code{n} by \code{d} matrix containing multivariate subgaussian stable
random variates where \code{d=nrow(Q)}.
}
\description{
Computes random vectors of the multivariate subgaussian stable
distribution for arbitrary alpha, shape matrices, and
location vectors. See Nolan (2013).
}
\examples{

rmvss(n=10, alpha=1.71, Q=matrix(c(10,7.5,7.5,10),2))

Q <- matrix(c(10,7.5,7.5,7.5,10,7.5,7.5,7.5,10),3)
rmvss(n=10, alpha=1.71, Q=Q)


}
\references{
Nolan JP (2013), \emph{Multivariate elliptically contoured stable distributions:
theory and estimation}. Comput Stat (2013) 28:2067–2089
DOI 10.1007/s00180-013-0396-7
}
\keyword{distribution}
