% Generated by roxygen2 (4.0.0.99): do not edit by hand
\name{get.nscales}
\alias{get.max.scale}
\alias{get.min.scale}
\alias{get.nscales}
\alias{log2Bins}
\alias{regularize}
\title{Utility functions}
\usage{
get.nscales(x)

get.min.scale(x)

get.max.scale(x)

log2Bins(min, max, nbins)

regularize(x, nsteps = length(as.vector(unlist(x))))
}
\arguments{
\item{x}{a vector of values}

\item{min}{smallest value in sequence}

\item{max}{largest value in sequence}

\item{nbins}{how many intervals}

\item{nsteps}{length of returned sequence}
}
\value{
\code{get.nscales}: length of \code{x} \code{\link{unlist}}ed and \code{\link{as.vector}}ized.

\code{get.min.scale}: twice the median distance between successive values of \code{x}

\code{get.max.scale}: 1/2 the maximum distance between values in \code{x}

\code{log2Bins}: a sequence of values on a log2 scale

\code{regularize}: a regular sequence of values
}
\description{
Functions for calculating scales and locations to analyze
}

