% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ops.R
\name{slice}
\alias{slice}
\title{Select rows by position}
\usage{
slice(.self, rows = NULL, start = NULL, end = NULL, each = FALSE,
  auto_compact = NULL)
}
\arguments{
\item{.self}{Data frame}

\item{rows}{Rows to select}

\item{start}{Start of range of rows}

\item{end}{End of range of rows}

\item{each}{Apply slice to each cluster/group}

\item{auto_compact}{Compact data}
}
\value{
Data frame
}
\description{
This function is used to filter out everything except a specified subset of
the data. The each parameter is used to change slice's behaviour to filter
out all except a specified subset within each group or, if no grouping,
within each node.
}
\examples{
\donttest{
dat <- Multiplyr (x=1:100, G=rep(c("A", "B", "C", "D"), each=25))
dat \%>\% group_by (G)
dat \%>\% slice (1:10, each=TRUE)
dat \%>\% slice (1:10)
dat \%>\% shutdown()
}
}
\seealso{
Other row manipulations: \code{\link{arrange}},
  \code{\link{distinct}}, \code{\link{filter}},
  \code{\link{group_by}}
}

