\name{strings}
\alias{strings}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Strings of Relations
}
\description{
Function to get the labels of the unique relations of the semigroup; that is the generators and compound relations that are the elements of the complete semigroup.
}
\usage{
strings(x, smpl = FALSE, equat = FALSE, k = 2)
}
\arguments{
  \item{x}{
   an array; usually with three dimensions of stacked matrices where the multiple relations are placed.
}
  \item{smpl}{
(logical) whether to simplify or not the strings of relations
}
  \item{equat}{
(logical) should the equations be included in the output?
}
  \item{k}{
length of the strings
}
}
\details{
The strings are the unique relations which constitutes the elements of the complete semigroup. These are both the generators and the compound relations after applying the Axiom of Quality, which means that even some generators can be diregarded. 

This function is specially useful to construct the partial order of relations, and to establish the set of equations in the relational structure.
}
\value{
An object of `\code{Strings}' class.
  \item{wt}{
  the generators and compound relations
  }
  \item{ord}{
  the order of the structure
  }
  \item{st}{
  the labels of the unique relations
  }
  \item{equat}{
  the equations among strings of relations
  }
}
\references{
Boorman, S.A. and H.C. White, `Social Structure from Multiple Networks. II. Role Structures.' \emph{American Journal of Sociology}, 81 (6), 1384-1446. 1976.
}
\author{
Antonio Rivero Ostoic
}
\note{
The maximum length of the strings in the equations is currently 3.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{partial.order}}, \code{\link{semigroup}}, \code{\link{ltlw}}.
}
\examples{
## Create the data: 2 binary relations among 3 elements
arr <- round( replace( array(runif(18), c(3,3,2)), array(runif(18),
       c(3,3,2))>.5, 1 ) )

## get the strings
strings(arr)

}
%% Add one or more standard keywords, see file 'KEYWORDS' in the
\keyword{ algebra }
\keyword{ array }
