% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_weights.R
\name{model_weights}
\alias{model_weights}
\title{Get Posterior/NML Model Weights}
\usage{
model_weights(x, prior)
}
\arguments{
\item{x}{vector or matrix of log-marginal probabilities or negative NML values (if matrix: one model per column)}

\item{prior}{vector of prior model probabilities (default: uniform over models). The vector is normalized internally to sum to one.}
}
\description{
Computes the posterior model probabilities based on the log-marginal likelihoods/negative NML values.
}
\examples{
logmarginal <- c(-3.4, -2.0, -10.7)
model_weights(logmarginal)

nml <- matrix(c(2.5, 3.1, 4.2,
                1.4, 0.3, 8.2), nrow = 2, byrow = TRUE)
model_weights(-nml)
}
