% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc_array-class.R
\name{mcmc_array-class}
\alias{mcmc_array-class}
\alias{mcmc_array}
\alias{summary.mcmc_array}
\alias{print.mcmc_array}
\alias{names.mcmc_array}
\alias{names<-.mcmc_array}
\title{Working with 3D MCMC arrays}
\usage{
\method{summary}{mcmc_array}(object, ..., probs = c(0.025, 0.25, 0.5, 0.75, 0.975))

\method{print}{mcmc_array}(x, ...)

\method{names}{mcmc_array}(x)

\method{names}{mcmc_array}(x) <- value
}
\arguments{
\item{...}{Further arguments passed to other methods}

\item{probs}{Numeric vector of quantiles of interest}

\item{x, object}{A 3D MCMC array of class \code{mcmc_array}}

\item{value}{Character vector of replacement parameter names}
}
\value{
The \code{summary()} method returns a \link{nma_summary} object, the \code{print()}
method returns \code{x} invisibly. The \code{names()} method returns a character
vector of parameter names, and \verb{names()<-} returns the object with updated
parameter names.
}
\description{
3D MCMC arrays (Iterations, Chains, Parameters) are produced by \code{as.array()}
methods applied to \code{stan_nma} or \code{nma_summary} objects.
}
\examples{
## Smoking cessation
\donttest{
# Run smoking RE NMA example if not already available
if (!exists("smk_fit_RE")) example("example_smk_re", run.donttest = TRUE)
}
\donttest{
# Working with arrays of posterior draws (as mcmc_array objects) is
# convenient when transforming parameters

# Transforming log odds ratios to odds ratios
LOR_array <- as.array(relative_effects(smk_fit_RE))
OR_array <- exp(LOR_array)

# mcmc_array objects can be summarised to produce a nma_summary object
smk_OR_RE <- summary(OR_array)

# This can then be printed or plotted
smk_OR_RE
plot(smk_OR_RE, ref_line = 1)

# Transforming heterogeneity SD to variance
tau_array <- as.array(smk_fit_RE, pars = "tau")
tausq_array <- tau_array^2

# Correct parameter names
names(tausq_array) <- "tausq"

# Summarise
summary(tausq_array)
}
}
