% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/partydf.R
\name{party_df}
\alias{party_df}
\title{A `party_df` partitioned data frame}
\usage{
party_df(cluster, name, auto_rm = FALSE)
}
\arguments{
\item{cluster}{A cluster}

\item{name}{Name of data frame variable. Must exist on every worker,
be a data frame, and have the same names.}

\item{auto_rm}{If `TRUE`, will automatically `rm()` the data frame on
the workers when this object is created.}
}
\value{
An S3 object with class `multidplyr_party_df`.
}
\description{
This S3 class represents a data frame partitioned across workers in a
cluster. You can use this constructor if you have already spread
data frames spread across a cluster. If not, start with [partition()]
instead.
}
\examples{
# If a real example, you might spread file names across the clusters
# and read in using data.table::fread()/vroom::vroom()/qs::qread().
cl <- default_cluster()
cluster_send(cl[1], n <- 10)
cluster_send(cl[2], n <- 15)
cluster_send(cl, df <- data.frame(x = runif(n)))

df <- party_df(cl, "df")
df
}
