% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_uc_emc.R
\name{adjust_uc_emc}
\alias{adjust_uc_emc}
\title{Adust for uncontrolled confounding and exposure misclassification.}
\usage{
adjust_uc_emc(
  data,
  exposure,
  outcome,
  confounders = NULL,
  u_model_coefs,
  x_model_coefs,
  level = 0.95
)
}
\arguments{
\item{data}{Dataframe for analysis.}

\item{exposure}{String name of the exposure variable.}

\item{outcome}{String name of the outcome variable.}

\item{confounders}{String name(s) of the confounder(s).
A maximum of three confounders are allowed.}

\item{u_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(U=1)) = &alpha;<sub>0</sub> +
&alpha;<sub>1</sub>X + &alpha;<sub>2</sub>Y, }
where U is the (binary) unmeasured confounder, X is the (binary) true
exposure, Y is the (binary) outcome. The number of parameters therefore
equals 3.}{\eqn{logit(P(U=1)) =}}}

\item{x_model_coefs}{The regression coefficients corresponding to the model:
\ifelse{html}{\out{logit(P(X=1)) = &delta;<sub>0</sub> +
&delta;<sub>1</sub>X* + &delta;<sub>2</sub>Y +
&delta;<sub>2+j</sub>C<sub>j</sub>, } where X represents (binary) true
exposure, X* is the (binary) misclassified exposure, Y is the (binary)
outcome, C represents the vector of (binary) measured confounders (if any),
and j corresponds to the number of measured confounders. The number of
parameters is therefore 3 + j.}{\eqn{logit(P(X=1)) =}}}

\item{level}{Value from 0-1 representing the full range of the confidence
interval. Default is 0.95.}
}
\value{
A list where the first item is the odds ratio estimate of the
 effect of the exposure on the outcome and the second item is the
 confidence interval as the vector: (lower bound, upper bound).
}
\description{
\code{adjust_uc_emc} returns the exposure-outcome odds ratio and confidence
interval, adjusted for uncontrolled confounding and exposure
misclassificaiton.
}
\details{
This function uses two separate logistic regression models to predict the
uncontrolled confounder (U) and exposure (X). If a single bias model for
jointly modeling X and U is desired use \code{adjust_multinom_uc_emc}.

Values for the regression coefficients can be applied as
fixed values or as single draws from a probability
distribution (ex: \code{rnorm(1, mean = 2, sd = 1)}). The latter has
the advantage of allowing the researcher to capture the uncertainty
in the bias parameter estimates. To incorporate this uncertainty in the
estimate and confidence interval, this function should be run in loop across
bootstrap samples of the dataframe for analysis. The estimate and
confidence interval would then be obtained from the median and quantiles
of the distribution of odds ratio estimates.
}
\examples{
adjust_uc_emc(
  df_uc_emc,
  exposure = "Xstar",
  outcome = "Y",
  confounders = "C1",
  u_model_coefs = c(-0.23, 0.63, 0.66),
  x_model_coefs = c(-2.47, 1.62, 0.73, 0.32)
)

}
