% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{solve_ieu}
\alias{solve_ieu}
\title{Solve ODE System by Implicite Euler Scheme}
\usage{
solve_ieu(invdt, x0_, M, ali, s, ilua)
}
\arguments{
\item{invdt}{A numeric vactor, represents 1/dt}

\item{x0_}{A numeric matrix or NULL, is the starting value at t0 (NULL means 0)}

\item{M}{A numeric matrix representing diagonal terms (masses)}

\item{ali}{A list of matrices or Rmumps objects}

\item{s}{A 3d numeric array, is the source term, its last margin corresponds to time. \code{s[,,i]} can be a matrix or a vector(== 1-column matrix)}

\item{ilua}{An integer vector, \code{ilua[i]} gives the list index in \code{ali} for a given \eqn{dt_i}. In such a way, \code{ali} may be shorter than time points.}
}
\value{
None
}
\description{
The system is defined as \eqn{M*dx/dt=a*x+s} where M is a diagonal
matrix given by its diagonal vector M (which has a form of matrix for
term-by-term multiplication with x0)
In discrete terms
\eqn{(M/dt_i-a)*x_i=(M/dt_i)*x_(i-1)+s_i}
The rmumps matrix \eqn{(M/dt_i-a)} is stored in list ali as XPtr<Rmumps>
or a plain dense inverted matrix.
Calculations are done in-place so s is modified and contains the
solution on exit. The others parameters are not modified.
}
