% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start.em.1level.R
\name{mult.em_1level}
\alias{mult.em_1level}
\title{EM algorithm for multivariate one level model with covariates}
\arguments{
\item{data}{A data set object; we denote the dimension to be \eqn{m}.}

\item{v}{Covariate(s).}

\item{K}{Number of mixture components, the default is \code{K = 2}. Note that when \code{K = 1}, \code{z} and \code{beta} will be 0.}

\item{steps}{Number of iterations, the default is \code{steps = 20}.}

\item{start}{Containing parameters involved in the proposed model (\code{p}, \code{alpha}, \code{z}, \code{beta}, \code{sigma}, \code{gamma}) in a list,
the starting values can be obtained through the use of \link{start_em}. More details can be found in \link{start_em}.}

\item{option}{Four options for selecting the starting values for the parameters in the model. The default is option = 1.
More details can be found in \link{start_em}.}

\item{var_fun}{There are four types of variance specifications;
\code{var_fun = 1}, the same diagonal variance specification to all \code{K} components of the mixture;
\code{var_fun = 2}, different diagonal variance matrices for different components.
\code{var_fun = 3}, the same full (unrestricted) variance for all components.
\code{var_fun = 4}, different full (unrestricted) variance matrices for different components.
The default is \code{var_fun = 2}.}
}
\value{
The estimated parameters in the model \eqn{x_{i} = \alpha + \beta z_k + \Gamma v_i + \varepsilon_i} obtained through the EM algorithm at the convergence.
 \item{p}{The estimates for the parameter \eqn{\pi_k}, which is a vector of length \eqn{K}.}
 \item{alpha}{The estimates for the parameter \eqn{\alpha}, which is a vector of length \eqn{m}.}
 \item{z}{The estimates for the parameter \eqn{z_k}, which is a vector of length \eqn{K}.}
 \item{beta}{The estimates for the parameter \eqn{\beta}, which is a vector of length \eqn{m}.}
 \item{gamma}{The estimates for the parameter \eqn{\Gamma}, which is a matrix.}
 \item{sigma}{The estimates for the parameter \eqn{\Sigma_k}.
                     When \code{var_fun = 1}, \eqn{\Sigma_k} is a diagonal matrix and \eqn{\Sigma_k = \Sigma}, and we obtain a vector of the diagonal elements;
                     When \code{var_fun = 2}, \eqn{\Sigma_k} is a diagonal matrix, and we obtain \code{K} vectors of the diagonal elements;
                     When \code{var_fun = 3}, \eqn{\Sigma_k} is a full variance-covariance matrix, \eqn{\Sigma_k = \Sigma}, and we obtain a matrix \eqn{\Sigma};
                     When \code{var_fun = 4}, \eqn{\Sigma_k} is a full variance-covariance matrix, and we obtain \code{K} different matrices \eqn{\Sigma_k}.}
 \item{W}{The posterior probability matrix.}
 \item{loglikelihood}{The approximated log-likelihood of the fitted model.}
 \item{disparity}{The disparity (\code{-2logL}) of the fitted model.}
 \item{number_parameters}{The number of parameters estimated in the EM algorithm.}
 \item{AIC}{The AIC value (\code{-2logL + 2number_parameters}).}
 \item{BIC}{The BIC value (\code{-2logL + number_parameters*log(n)}), where n is the number of observations.}
 \item{starting_values}{A list of starting values for parameters used in the EM algorithm.}
}
\description{
This function is used to obtain the Maximum Likelihood Estimates (MLE) using the EM algorithm for one-level multivariate data.
             The estimates enable users to conduct clustering, ranking, and simultaneous dimension reduction on the multivariate dataset.
             Furthermore, when covariates are included, the function supports the fitting of multivariate response models, expanding its utility for regression analysis.
             The details of the model used in this function can be found in Zhang and Einbeck (2024).
}
\examples{
##example for data without covariates.
data(faithful)
res <- mult.em_1level(faithful,K=2,steps = 10,var_fun = 1)


## Graph showing the estimated one-dimensional space with cluster centers in red and alpha in green.
x <- res$alpha[1]+res$beta[1]*res$z
y <- res$alpha[2]+res$beta[2]*res$z
plot(faithful,col = 8)
points(x=x[1],y=y[1],type = "p",col = "red",pch = 17)
points(x=x[2],y=y[2],type = "p",col = "red",pch = 17)
points(x=res$alpha[1],y=res$alpha[2],type = "p",col = "darkgreen",pch = 4)
slope <- (y[2]-y[1])/(x[2]-x[1])
intercept <- y[1]-slope*x[1]
abline(intercept, slope, col="red")

##Graph showing the originaldata points being assigned to different
 ##clusters according to the Maximum a posterior (MAP) rule.
index <- apply(res$W, 1, which.max)
faithful_grouped <- cbind(faithful,index)
colors <- c("#FDAE61", "#66BD63")
plot(faithful_grouped[,-3], pch = 1, col = colors[factor(index)])

\donttest{
##example for data with covariates.
data(fetal_covid_data)
set.seed(2)
covid_res <- mult.em_1level(fetal_covid_data[,c(1:5)],v=fetal_covid_data$status_bi, K=3, steps = 20,
             var_fun = 2)
coeffs <- covid_res$gamma
##compare with regression coefficients from fitting individual linear models.
summary(lm( UpperFaceMovements ~ status_bi,data=fetal_covid_data))$coefficients[2,1]
summary(lm( Headmovements ~ status_bi,data=fetal_covid_data))$coefficients[2,1]
}
}
\references{
Zhang, Y. and Einbeck, J. (2024). A Versatile Model for Clustered and Highly Correlated Multivariate Data. J Stat Theory Pract 18(5).\doi{10.1007/s42519-023-00357-0}
}
\seealso{
\code{\link{mult.reg_1level}}.
}
