% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtvc.R
\name{mtvc}
\alias{mtvc}
\title{(mtvc) Multiple Time Varying Covariates}
\usage{
mtvc(data, dates, origin = "1970-01-01", start, stop, event, complications)
}
\arguments{
\item{data}{Dataframe to be restructured. Has to be in wide format, with a line for each individual.}

\item{dates}{Name of the columns that contains dates that point out when the variables of interest change value.
If an individual does not experience the event of interest, then the respective date should
be either a missing value or the origin date.}

\item{origin}{Day from which the function starts counting days to convert into dates.}

\item{start}{Date of first contact with the individual (i.e. first medical visit).}

\item{stop}{Date of death or last visit of the follow-up.}

\item{event}{Binary variable that indicates if the individual has experienced the event.}

\item{complications}{Name of the columns that contain values of time varying covariates.}
}
\value{
Dataset in counting process format.
}
\description{
Restructure dataset into counting process format to model time varying variables
}
\details{
Time varying variables are covariates that might change during the follow-up,
so it is fundamental to apply the counting process structure to the data frame of
interest, in order to allocate properly the right amount of time that each patient
has contributed to the study in each health status.
}
\examples{
data(simwide)
cp.dataframe=mtvc(data=simwide,
origin='1970-01-01',
dates=c(FIRST_CHRONIC,FIRST_ACUTE,FIRST_RELAPSE),
complications=c(CHRONIC,ACUTE,RELAPSE),
start=DATETRAN,
stop=DLASTSE,
event=EVENT)
}
\references{
1. F. W. Dekker, et al., Survival analysis: time-dependent effects and time-varying risk factors, Kidney International, Volume 74, Issue 8, 2008, Pages 994-997.
}
