% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_axis2.R
\name{trans_loglinear}
\alias{trans_loglinear}
\title{Transformation for continuous data with a finite number of distinct values}
\usage{
trans_loglinear(x = NULL, nb = 30, int = NA, scale = NA, mindist = 0.03)
}
\arguments{
\item{x}{A numerical vector used in a plot as (typically) \code{x}}

\item{nb}{An integer for the maximum number of breaks. Default=30}

\item{int}{One of
\itemize{
  \item NA for a value calculated automatically
  \item A real number (>=0) for the shift before log transform
}}

\item{scale}{One of
\itemize{
  \item NA for a value calculated automatically
  \item A real number (>0) for the scale before log transform
}}

\item{mindist}{One of
\itemize{
  \item NA for a default value set to 0.03
  \item A real number between 0 and 0.2 for the minimum distance ratio between major ticks
}}
}
\value{
A transformation function
}
\description{
\code{trans_loglinear()} derives a log transformation from a numerical vector with a smaller number (ideally < 30) of distinct values..
The return can be used with function \code{ggplot::scale_x_continuous()}
or \code{ggplot::scale_y_continuous()} to create a desired axis.
}
\examples{
library(ggplot2)
pdt=data.frame(x=rep(c(0.5, 1, 10,11,12, 100, 1000), each=5))
pdt$y=pdt$x+rnorm(length(pdt$x))
t=trans_loglinear(pdt$x)
ggplot(pdt, aes(x=x, y=y))+geom_point()+scale_x_continuous(trans=t)

}
