% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mssm.R
\name{mssm-smoother}
\alias{mssm-smoother}
\title{Computes Smoothed Particle Weights for Multivariate State Space
Model}
\arguments{
\item{object}{an object of class \code{mssm} from \link{mssm-pf}.}
}
\value{
Same as \link{mssm-pf} but where the \code{pf_output}'s list elements
has an additional element called \code{ws_normalized_smooth}. This
contains the normalized log smoothing weights.
}
\description{
Computes smoothed weights using the backward smoothing formula for a
\code{mssm} object. The k-d dual tree approximation is also used if it used
for the \code{mssm} object.
}
\examples{
if(require(Ecdat)){
  # load data and get object to perform particle filtering
  data("Gasoline", package = "Ecdat")

  library(mssm)
  ll_func <- mssm(
    fixed = lgaspcar ~ factor(country) + lincomep + lrpmg + lcarpcap,
    random = ~ 1, family = Gamma("log"), data = Gasoline, ti = year,
    control = mssm_control(N_part = 1000L, n_threads = 1L))

  # run particle filter
  cfix <- c(0.612, -0.015, 0.214, 0.048, -0.013, -0.016, -0.022, 0.047,
            -0.046, 0.007, -0.001, 0.008, -0.117, 0.075, 0.048, -0.054, 0.017,
            0.228, 0.077, -0.056, -0.139)
  pf <- ll_func$pf_filter(
    cfix = cfix, Q = as.matrix(2.163e-05), F. = as.matrix(0.9792),
    disp = 0.000291)

  print(is.null(pf$pf_output[[1L]]$ws_normalized_smooth))
  pf <- ll_func$smoother(pf)
  print(is.null(pf$pf_output[[1L]]$ws_normalized_smooth))
}
}
\seealso{
\code{\link{mssm}}.
}
