% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_mrgmod.R, R/update.R
\docType{methods}
\name{update}
\alias{update}
\alias{names,mrgmod-method}
\alias{update}
\alias{update,mrgmod-method}
\alias{update,omegalist-method}
\alias{update,sigmalist-method}
\alias{update,parameter_list-method}
\alias{update,ev-method}
\title{Get all names from a model object.}
\usage{
\S4method{names}{mrgmod}(x)

\S4method{update}{mrgmod}(object, ..., merge = TRUE, open = FALSE,
  data = list())

\S4method{update}{omegalist}(object, y, ...)

\S4method{update}{sigmalist}(object, y, ...)

\S4method{update}{parameter_list}(object, y, ...)

\S4method{update}{ev}(object, y, ...)
}
\arguments{
\item{x}{the model object}

\item{object}{a model object}

\item{...}{passed to other functions}

\item{merge}{logical indicating to merge (rather than replace) new and
existing attributes.}

\item{open}{logical; used only when merge is \code{TRUE} and parameter list or initial conditions
list is being updated; if \code{FALSE}, no new items will be added; if \code{TRUE}, the parameter list may
expand.}

\item{data}{a list of items to update; not used for now}

\item{y}{another object involved in update}
}
\value{
The updated model object is returned.
}
\description{
Get all names from a model object.

After the model object is created, update various attributes.
}
\examples{
mod <- mrgsolve:::house()
names(mod)

\dontrun{
 mod <- mrgsolve:::house()

 mod <- update(mod, end=120, delta=4, param=list(CL=19.1))
 }
}
