% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream-file.R
\name{file_set}
\alias{file_set}
\title{Generate a sequence of file objects}
\usage{
file_set(n, where = NULL, prefix = NULL, pad = TRUE, sep = "-", ext = "")
}
\arguments{
\item{n}{The number of file names to create.}

\item{where}{An optional output file path.}

\item{prefix}{A character prefix for the file name.}

\item{pad}{If \code{TRUE}, numbers will be padded with zeros.}

\item{sep}{Separator character.}

\item{ext}{A file extension, including the dot.}
}
\value{
By default a list length \code{n} of lists length 2; each sublist contains the
integer file number as \code{i} and the file name as \code{file}.
}
\description{
File names have a numbered core that communicates the current file number
as well as the total number of files in the set. For example, \code{02-20} would
indicate the second file in a set of 20. Other customizations can be added.
}
\examples{

x <- file_set(3, where = "foo/bar")
length(x)
x[2]

x <- file_set(25, ext = ".feather")
x[17]

}
\seealso{
\code{\link[=setup_locker]{setup_locker()}}
}
