% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mreg.R
\name{summary.mreg}
\alias{summary.mreg}
\title{Prints a summary of an mreg object}
\usage{
\method{summary}{mreg}(
  object,
  digits = max(3, getOption("digits") - 3),
  symbolic.cor = object$symbolic.cor,
  signif.stars = getOption("show.signif.stars"),
  ...
)
}
\arguments{
\item{object}{An \code{\link{mreg}} object}

\item{digits}{the number of significant digits to use when printing.}

\item{symbolic.cor}{logical. If \code{TRUE}, print the correlations in
    a symbolic form (see \code{\link[stats]{symnum}}) rather than as numbers.}

\item{signif.stars}{logical. If \code{TRUE}, \sQuote{significance stars}
    are printed for each coefficient.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
prints to output a description of the fitted model.
}
\description{
@description Similar to \code{\link{summary.glm}}, it prints the coefficients,
standard errors, Wald tests, residuals (if available) and dispersion from
an \code{\link{mreg}} object.
}
\seealso{
\code{\link{mreg}} \code{\link{print.mreg}}
}
\keyword{print}
