% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{mrbin}
\alias{mrbin}
\title{A function setting the parameters and performing binning and data processing}
\usage{
mrbin(
  silent = FALSE,
  setDefault = FALSE,
  parameters = NULL,
  metadata = NULL,
  graphics = TRUE
)
}
\arguments{
\item{silent}{If TRUE, the user will be asked no questions and binning and data analysis will run according to the current parameters. Defaults to FALSE.}

\item{setDefault}{If TRUE, all current parameters will be replaced by the default parameters (before loading any provided parameters sets). Defaults to FALSE.}

\item{parameters}{Optional: A list of parameters, see examples for details. If omitted, the user will be asked through a series of question to set the parameters.}

\item{metadata}{Optional: A list of metadata. If omitted, the user can add metadata after generating bin data.}

\item{graphics}{Controls whether pop-up windows are shown for selections. Defaults to TRUE.}
}
\value{
An invisible object of type "mrbin" containing bins (data after processing), parameters, and factors
}
\description{
This function guides the user through the set-up of parameters, starts binning
and performs the chosen data processing steps.
If a list of parameters is provided and silent is set to TRUE, no user input
is requested and binning and data processing are performed silently.
}
\examples{
# Set parameters in command line.
results<-mrbin(silent=TRUE,setDefault=TRUE,parameters=list(
                dimension="1D",binwidth1D=0.01,tryParallel=TRUE,
                signal_to_noise1D=25,noiseThreshold=0.75,useAsNames="Spectrum titles",
                NMRfolders=c(
                system.file("extdata/1/10/pdata/10",package="mrbin"),
                system.file("extdata/2/10/pdata/10",package="mrbin"),
                system.file("extdata/3/10/pdata/10",package="mrbin"))
                ))
}
